#include "grafStartUpApp.h"

//--------------------------------------------------------------
grafStartUpApp::grafStartUpApp(){


}

grafStartUpApp::~grafStartUpApp(){


}
//--------------------------------------------------------------
void grafStartUpApp::setup(){
	
	bgImage.loadImage("images/bg.png");
	fontS.loadFont("fonts/frabk.ttf",12);
	fontSS.loadFont("fonts/frabk.ttf",10);
	alpha = 1;
	bOn = true;
	bAllLoaded = false;
	waitTime = .5;
	waitCounter = waitTime;
}


//--------------------------------------------------------------
void grafStartUpApp::update(float dt){
	
	if(!bOn && alpha > 0 ) alpha -= dt*.5;
	else if( bOn && alpha < 1 ) alpha += dt*.5;
	
	if( bAllLoaded && waitCounter > 0 ) waitCounter -= dt;
}


//--------------------------------------------------------------
void grafStartUpApp::draw( string file, string dir){
	
	if(alpha <= 0 ) return;
	
	ofSetColor(255,255,255,255*alpha);
	bgImage.draw(0,0);
	
	int xp = 625;
	int yp = 220;
	
	fontSS.drawString("Graffiti Analysis 2.0 par Evan Roth.",xp,yp);
	fontSS.drawString("Développement du logiciel par Chris Sugrue.",xp,yp+20);
	fontSS.drawString("Conforme à tous les standards du Graffiti Markup Language (GML).",xp,yp+40);
	fontSS.drawString("GNU General Public License.",xp,yp+60);
	fontSS.drawString("graffitianalysis.com", xp, yp+90);
	
	ofLine(xp,yp+110,xp+350,yp+110);
	
	yp = yp+140;
	
	fontS.drawString("Chargement des tags:  "+file, xp, yp);
	
	ofLine(xp,yp+20,xp+350,yp+20);
	
	//fontSS.drawString("Current directory: "+dir, xp, yp+65);
	
	
	fontS.drawString("Taper 'x' pour accéder au panel de contrôle\n", xp, yp+65);
	fontS.drawString("Dossier actuel: "+dir, xp, yp+100);
	fontSS.drawString("Pour changer:\ndata/settings/directorSettings.xml",xp,yp+120);
	
}

